/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.verification;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.impl.verification.CommandExecResultImpl;
import oracle.cluster.verification.CommandExecOverallStatus;
import oracle.cluster.verification.CommandExecResult;
import oracle.cluster.verification.CommandExecResultSet;
import oracle.cluster.verification.CommandExecResultStatus;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CommandExecResultSetImpl
implements CommandExecResultSet {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private boolean m_anyExecutionFailure = false;
    private List<String> m_succNodes = new ArrayList<String>();
    private List<String> m_failNodes = new ArrayList<String>();
    private List<VerificationError> m_overallErrors = new ArrayList<VerificationError>();
    private Hashtable m_resultTable = new Hashtable();

    public CommandExecResultSetImpl(String[] nodeList) {
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            this.m_resultTable.put(node, new CommandExecResultImpl(node));
            this.m_failNodes.add(node);
        }
    }

    public void setErrors(ResultSet sourceResultSet) {
        this.m_anyExecutionFailure = true;
        Hashtable t = sourceResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result srcNodeRes = (Result)t.get(node);
            CommandExecResultImpl destNodeRes = (CommandExecResultImpl)this.m_resultTable.get(node);
            destNodeRes.addErrorDescription(srcNodeRes.getErrors());
        }
        this.m_overallErrors.addAll(sourceResultSet.getErrors());
    }

    public void setCommandExecutionResults(Hashtable htExec) {
        Trace.out((String)("htExec.size()=" + htExec.size()));
        Enumeration e = htExec.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            CommandExecResultImpl cmdExecResImpl = (CommandExecResultImpl)this.m_resultTable.get(node);
            String execTaskStr = (String)htExec.get(node);
            String cmdOutput = null;
            Trace.out((String)("For node '" + node + "' execTaskStr is==>" + execTaskStr + "<=="));
            if (!VerificationUtil.fetchExecResult(execTaskStr)) {
                this.m_anyExecutionFailure = true;
                Trace.out((String)("For node '" + node + "': Execution result is NULL. "));
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7558", false, (Object[])new String[]{node}));
                cmdOutput = VerificationUtil.fetchVerificationValue(execTaskStr);
                Trace.out((String)("For node '" + node + "': error output is==>" + cmdOutput));
                if (cmdOutput != null && cmdOutput.length() != 0) {
                    errDesc.setCause(cmdOutput);
                }
                cmdExecResImpl.addErrorDescription(errDesc);
                continue;
            }
            cmdExecResImpl.setCommandExecResultStatus(CommandExecResultStatus.EXECUTED);
            String verResult = VerificationUtil.fetchVerificationResult(execTaskStr);
            Trace.out((String)("Verification result = " + verResult));
            if (verResult == null || verResult.length() == 0) {
                Trace.out((String)("For node '" + node + "': verResult is NULL."));
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7558", false, (Object[])new String[]{node}));
                cmdExecResImpl.addErrorDescription(errDesc);
                continue;
            }
            int exitStatus = Integer.parseInt(verResult);
            Trace.out((String)("For node '" + node + "': exitStatus = " + exitStatus));
            cmdExecResImpl.setCommandExitValue(exitStatus);
            cmdOutput = VerificationUtil.fetchVerificationValue(execTaskStr);
            Trace.out((String)("For node '" + node + "': cmdOutput is==>" + cmdOutput + "<=="));
            cmdExecResImpl.setCommandOutput(cmdOutput);
            this.m_failNodes.remove(node);
            this.m_succNodes.add(node);
        }
        Trace.out((String)("m_succNodes = " + VerificationUtil.strList2List(this.m_succNodes)));
        Trace.out((String)("m_failNodes = " + VerificationUtil.strList2List(this.m_failNodes)));
    }

    @Override
    public CommandExecOverallStatus getOverallStatus() {
        if (this.m_anyExecutionFailure) {
            return CommandExecOverallStatus.FAILED;
        }
        return CommandExecOverallStatus.SUCCESSFUL;
    }

    @Override
    public List<String> getSuccessfulNodes() {
        return this.m_succNodes;
    }

    @Override
    public List<String> getFailedNodes() {
        return this.m_failNodes;
    }

    @Override
    public List<CommandExecResult> getNodeResults() throws NodeResultsUnavailableException {
        if (this.m_resultTable.isEmpty()) {
            throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
        }
        ArrayList<CommandExecResult> nodeResults = new ArrayList<CommandExecResult>(this.m_resultTable.size());
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            nodeResults.add((CommandExecResult)this.m_resultTable.get(node));
        }
        return nodeResults;
    }

    @Override
    public CommandExecResult getNodeResult(String node) throws NodeResultsUnavailableException {
        if (this.m_resultTable.isEmpty()) {
            throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
        }
        return (CommandExecResult)this.m_resultTable.get(node);
    }

    @Override
    public List<VerificationError> getErrors() {
        return this.m_overallErrors;
    }

    @Override
    public boolean hasNodeResults() {
        return !this.m_resultTable.isEmpty();
    }

    public void addErrorDescription(ErrorDescription errorDesc) {
        this.m_overallErrors.add(errorDesc);
    }

    public void addErrorDescription(List<VerificationError> errorDescList) {
        this.m_overallErrors.addAll(errorDescList);
    }
}

